// Created with Squiffy 5.1.3
// https://github.com/textadventures/squiffy

(function(){
/* jshint quotmark: single */
/* jshint evil: true */

var squiffy = {};

(function () {
    'use strict';

    squiffy.story = {};

    var initLinkHandler = function () {
        var handleLink = function (link) {
            if (link.hasClass('disabled')) return;
            var passage = link.data('passage');
            var section = link.data('section');
            var rotateAttr = link.attr('data-rotate');
            var sequenceAttr = link.attr('data-sequence');
            if (passage) {
                disableLink(link);
                squiffy.set('_turncount', squiffy.get('_turncount') + 1);
                passage = processLink(passage);
                if (passage) {
                    currentSection.append('<hr/>');
                    squiffy.story.passage(passage);
                }
                var turnPassage = '@' + squiffy.get('_turncount');
                if (turnPassage in squiffy.story.section.passages) {
                    squiffy.story.passage(turnPassage);
                }
                if ('@last' in squiffy.story.section.passages && squiffy.get('_turncount')>= squiffy.story.section.passageCount) {
                    squiffy.story.passage('@last');
                }
            }
            else if (section) {
                currentSection.append('<hr/>');
                disableLink(link);
                section = processLink(section);
                squiffy.story.go(section);
            }
            else if (rotateAttr || sequenceAttr) {
                var result = rotate(rotateAttr || sequenceAttr, rotateAttr ? link.text() : '');
                link.html(result[0].replace(/&quot;/g, '"').replace(/&#39;/g, '\''));
                var dataAttribute = rotateAttr ? 'data-rotate' : 'data-sequence';
                link.attr(dataAttribute, result[1]);
                if (!result[1]) {
                    disableLink(link);
                }
                if (link.attr('data-attribute')) {
                    squiffy.set(link.attr('data-attribute'), result[0]);
                }
                squiffy.story.save();
            }
        };

        squiffy.ui.output.on('click', 'a.squiffy-link', function () {
            handleLink(jQuery(this));
        });

        squiffy.ui.output.on('keypress', 'a.squiffy-link', function (e) {
            if (e.which !== 13) return;
            handleLink(jQuery(this));
        });

        squiffy.ui.output.on('mousedown', 'a.squiffy-link', function (event) {
            event.preventDefault();
        });
    };

    var disableLink = function (link) {
        link.addClass('disabled');
        link.attr('tabindex', -1);
    }
    
    squiffy.story.begin = function () {
        if (!squiffy.story.load()) {
            squiffy.story.go(squiffy.story.start);
        }
    };

    var processLink = function(link) {
		link = String(link);
        var sections = link.split(',');
        var first = true;
        var target = null;
        sections.forEach(function (section) {
            section = section.trim();
            if (startsWith(section, '@replace ')) {
                replaceLabel(section.substring(9));
            }
            else {
                if (first) {
                    target = section;
                }
                else {
                    setAttribute(section);
                }
            }
            first = false;
        });
        return target;
    };

    var setAttribute = function(expr) {
        var lhs, rhs, op, value;
        var setRegex = /^([\w]*)\s*=\s*(.*)$/;
        var setMatch = setRegex.exec(expr);
        if (setMatch) {
            lhs = setMatch[1];
            rhs = setMatch[2];
            if (isNaN(rhs)) {
				if(startsWith(rhs,"@")) rhs=squiffy.get(rhs.substring(1));
                squiffy.set(lhs, rhs);
            }
            else {
                squiffy.set(lhs, parseFloat(rhs));
            }
        }
        else {
			var incDecRegex = /^([\w]*)\s*([\+\-\*\/])=\s*(.*)$/;
            var incDecMatch = incDecRegex.exec(expr);
            if (incDecMatch) {
                lhs = incDecMatch[1];
                op = incDecMatch[2];
				rhs = incDecMatch[3];
				if(startsWith(rhs,"@")) rhs=squiffy.get(rhs.substring(1));
				rhs = parseFloat(rhs);
                value = squiffy.get(lhs);
                if (value === null) value = 0;
                if (op == '+') {
                    value += rhs;
                }
                if (op == '-') {
                    value -= rhs;
                }
				if (op == '*') {
					value *= rhs;
				}
				if (op == '/') {
					value /= rhs;
				}
                squiffy.set(lhs, value);
            }
            else {
                value = true;
                if (startsWith(expr, 'not ')) {
                    expr = expr.substring(4);
                    value = false;
                }
                squiffy.set(expr, value);
            }
        }
    };

    var replaceLabel = function(expr) {
        var regex = /^([\w]*)\s*=\s*(.*)$/;
        var match = regex.exec(expr);
        if (!match) return;
        var label = match[1];
        var text = match[2];
        if (text in squiffy.story.section.passages) {
            text = squiffy.story.section.passages[text].text;
        }
        else if (text in squiffy.story.sections) {
            text = squiffy.story.sections[text].text;
        }
        var stripParags = /^<p>(.*)<\/p>$/;
        var stripParagsMatch = stripParags.exec(text);
        if (stripParagsMatch) {
            text = stripParagsMatch[1];
        }
        var $labels = squiffy.ui.output.find('.squiffy-label-' + label);
        $labels.fadeOut(1000, function() {
            $labels.html(squiffy.ui.processText(text));
            $labels.fadeIn(1000, function() {
                squiffy.story.save();
            });
        });
    };

    squiffy.story.go = function(section) {
        squiffy.set('_transition', null);
        newSection();
        squiffy.story.section = squiffy.story.sections[section];
        if (!squiffy.story.section) return;
        squiffy.set('_section', section);
        setSeen(section);
        var master = squiffy.story.sections[''];
        if (master) {
            squiffy.story.run(master);
            squiffy.ui.write(master.text);
        }
        squiffy.story.run(squiffy.story.section);
        // The JS might have changed which section we're in
        if (squiffy.get('_section') == section) {
            squiffy.set('_turncount', 0);
            squiffy.ui.write(squiffy.story.section.text);
            squiffy.story.save();
        }
    };

    squiffy.story.run = function(section) {
        if (section.clear) {
            squiffy.ui.clearScreen();
        }
        if (section.attributes) {
            processAttributes(section.attributes);
        }
        if (section.js) {
            section.js();
        }
    };

    squiffy.story.passage = function(passageName) {
        var passage = squiffy.story.section.passages[passageName];
        if (!passage) return;
        setSeen(passageName);
        var masterSection = squiffy.story.sections[''];
        if (masterSection) {
            var masterPassage = masterSection.passages[''];
            if (masterPassage) {
                squiffy.story.run(masterPassage);
                squiffy.ui.write(masterPassage.text);
            }
        }
        var master = squiffy.story.section.passages[''];
        if (master) {
            squiffy.story.run(master);
            squiffy.ui.write(master.text);
        }
        squiffy.story.run(passage);
        squiffy.ui.write(passage.text);
        squiffy.story.save();
    };

    var processAttributes = function(attributes) {
        attributes.forEach(function (attribute) {
            if (startsWith(attribute, '@replace ')) {
                replaceLabel(attribute.substring(9));
            }
            else {
                setAttribute(attribute);
            }
        });
    };

    squiffy.story.restart = function() {
        if (squiffy.ui.settings.persist && window.localStorage) {
            var keys = Object.keys(localStorage);
            jQuery.each(keys, function (idx, key) {
                if (startsWith(key, squiffy.story.id)) {
                    localStorage.removeItem(key);
                }
            });
        }
        else {
            squiffy.storageFallback = {};
        }
        if (squiffy.ui.settings.scroll === 'element') {
            squiffy.ui.output.html('');
            squiffy.story.begin();
        }
        else {
            location.reload();
        }
    };

    squiffy.story.save = function() {
        squiffy.set('_output', squiffy.ui.output.html());
    };

    squiffy.story.load = function() {
        var output = squiffy.get('_output');
        if (!output) return false;
        squiffy.ui.output.html(output);
        currentSection = jQuery('#' + squiffy.get('_output-section'));
        squiffy.story.section = squiffy.story.sections[squiffy.get('_section')];
        var transition = squiffy.get('_transition');
        if (transition) {
            eval('(' + transition + ')()');
        }
        return true;
    };

    var setSeen = function(sectionName) {
        var seenSections = squiffy.get('_seen_sections');
        if (!seenSections) seenSections = [];
        if (seenSections.indexOf(sectionName) == -1) {
            seenSections.push(sectionName);
            squiffy.set('_seen_sections', seenSections);
        }
    };

    squiffy.story.seen = function(sectionName) {
        var seenSections = squiffy.get('_seen_sections');
        if (!seenSections) return false;
        return (seenSections.indexOf(sectionName) > -1);
    };
    
    squiffy.ui = {};

    var currentSection = null;
    var screenIsClear = true;
    var scrollPosition = 0;

    var newSection = function() {
        if (currentSection) {
            disableLink(jQuery('.squiffy-link', currentSection));
        }
        var sectionCount = squiffy.get('_section-count') + 1;
        squiffy.set('_section-count', sectionCount);
        var id = 'squiffy-section-' + sectionCount;
        currentSection = jQuery('<div/>', {
            id: id,
        }).appendTo(squiffy.ui.output);
        squiffy.set('_output-section', id);
    };

    squiffy.ui.write = function(text) {
        screenIsClear = false;
        scrollPosition = squiffy.ui.output.height();
        currentSection.append(jQuery('<div/>').html(squiffy.ui.processText(text)));
        squiffy.ui.scrollToEnd();
    };

    squiffy.ui.clearScreen = function() {
        squiffy.ui.output.html('');
        screenIsClear = true;
        newSection();
    };

    squiffy.ui.scrollToEnd = function() {
        var scrollTo, currentScrollTop, distance, duration;
        if (squiffy.ui.settings.scroll === 'element') {
            scrollTo = squiffy.ui.output[0].scrollHeight - squiffy.ui.output.height();
            currentScrollTop = squiffy.ui.output.scrollTop();
            if (scrollTo > currentScrollTop) {
                distance = scrollTo - currentScrollTop;
                duration = distance / 0.4;
                squiffy.ui.output.stop().animate({ scrollTop: scrollTo }, duration);
            }
        }
        else {
            scrollTo = scrollPosition;
            currentScrollTop = Math.max(jQuery('body').scrollTop(), jQuery('html').scrollTop());
            if (scrollTo > currentScrollTop) {
                var maxScrollTop = jQuery(document).height() - jQuery(window).height();
                if (scrollTo > maxScrollTop) scrollTo = maxScrollTop;
                distance = scrollTo - currentScrollTop;
                duration = distance / 0.5;
                jQuery('body,html').stop().animate({ scrollTop: scrollTo }, duration);
            }
        }
    };

    squiffy.ui.processText = function(text) {
        function process(text, data) {
            var containsUnprocessedSection = false;
            var open = text.indexOf('{');
            var close;
            
            if (open > -1) {
                var nestCount = 1;
                var searchStart = open + 1;
                var finished = false;
             
                while (!finished) {
                    var nextOpen = text.indexOf('{', searchStart);
                    var nextClose = text.indexOf('}', searchStart);
         
                    if (nextClose > -1) {
                        if (nextOpen > -1 && nextOpen < nextClose) {
                            nestCount++;
                            searchStart = nextOpen + 1;
                        }
                        else {
                            nestCount--;
                            searchStart = nextClose + 1;
                            if (nestCount === 0) {
                                close = nextClose;
                                containsUnprocessedSection = true;
                                finished = true;
                            }
                        }
                    }
                    else {
                        finished = true;
                    }
                }
            }
            
            if (containsUnprocessedSection) {
                var section = text.substring(open + 1, close);
                var value = processTextCommand(section, data);
                text = text.substring(0, open) + value + process(text.substring(close + 1), data);
            }
            
            return (text);
        }

        function processTextCommand(text, data) {
            if (startsWith(text, 'if ')) {
                return processTextCommand_If(text, data);
            }
            else if (startsWith(text, 'else:')) {
                return processTextCommand_Else(text, data);
            }
            else if (startsWith(text, 'label:')) {
                return processTextCommand_Label(text, data);
            }
            else if (/^rotate[: ]/.test(text)) {
                return processTextCommand_Rotate('rotate', text, data);
            }
            else if (/^sequence[: ]/.test(text)) {
                return processTextCommand_Rotate('sequence', text, data);   
            }
            else if (text in squiffy.story.section.passages) {
                return process(squiffy.story.section.passages[text].text, data);
            }
            else if (text in squiffy.story.sections) {
                return process(squiffy.story.sections[text].text, data);
            }
			else if (startsWith(text,'@') && !startsWith(text,'@replace')) {
				processAttributes(text.substring(1).split(","));
				return "";
			}
            return squiffy.get(text);
        }

        function processTextCommand_If(section, data) {
            var command = section.substring(3);
            var colon = command.indexOf(':');
            if (colon == -1) {
                return ('{if ' + command + '}');
            }

            var text = command.substring(colon + 1);
            var condition = command.substring(0, colon);
			condition = condition.replace("<", "&lt;");
            var operatorRegex = /([\w ]*)(=|&lt;=|&gt;=|&lt;&gt;|&lt;|&gt;)(.*)/;
            var match = operatorRegex.exec(condition);

            var result = false;

            if (match) {
                var lhs = squiffy.get(match[1]);
                var op = match[2];
                var rhs = match[3];

				if(startsWith(rhs,'@')) rhs=squiffy.get(rhs.substring(1));
				
                if (op == '=' && lhs == rhs) result = true;
                if (op == '&lt;&gt;' && lhs != rhs) result = true;
                if (op == '&gt;' && lhs > rhs) result = true;
                if (op == '&lt;' && lhs < rhs) result = true;
                if (op == '&gt;=' && lhs >= rhs) result = true;
                if (op == '&lt;=' && lhs <= rhs) result = true;
            }
            else {
                var checkValue = true;
                if (startsWith(condition, 'not ')) {
                    condition = condition.substring(4);
                    checkValue = false;
                }

                if (startsWith(condition, 'seen ')) {
                    result = (squiffy.story.seen(condition.substring(5)) == checkValue);
                }
                else {
                    var value = squiffy.get(condition);
                    if (value === null) value = false;
                    result = (value == checkValue);
                }
            }

            var textResult = result ? process(text, data) : '';

            data.lastIf = result;
            return textResult;
        }

        function processTextCommand_Else(section, data) {
            if (!('lastIf' in data) || data.lastIf) return '';
            var text = section.substring(5);
            return process(text, data);
        }

        function processTextCommand_Label(section, data) {
            var command = section.substring(6);
            var eq = command.indexOf('=');
            if (eq == -1) {
                return ('{label:' + command + '}');
            }

            var text = command.substring(eq + 1);
            var label = command.substring(0, eq);

            return '<span class="squiffy-label-' + label + '">' + process(text, data) + '</span>';
        }

        function processTextCommand_Rotate(type, section, data) {
            var options;
            var attribute = '';
            if (section.substring(type.length, type.length + 1) == ' ') {
                var colon = section.indexOf(':');
                if (colon == -1) {
                    return '{' + section + '}';
                }
                options = section.substring(colon + 1);
                attribute = section.substring(type.length + 1, colon);
            }
            else {
                options = section.substring(type.length + 1);
            }
            var rotation = rotate(options.replace(/"/g, '&quot;').replace(/'/g, '&#39;'));
            if (attribute) {
                squiffy.set(attribute, rotation[0]);
            }
            return '<a class="squiffy-link" data-' + type + '="' + rotation[1] + '" data-attribute="' + attribute + '" role="link">' + rotation[0] + '</a>';
        }

        var data = {
            fulltext: text
        };
        return process(text, data);
    };

    squiffy.ui.transition = function(f) {
        squiffy.set('_transition', f.toString());
        f();
    };

    squiffy.storageFallback = {};

    squiffy.set = function(attribute, value) {
        if (typeof value === 'undefined') value = true;
        if (squiffy.ui.settings.persist && window.localStorage) {
            localStorage[squiffy.story.id + '-' + attribute] = JSON.stringify(value);
        }
        else {
            squiffy.storageFallback[attribute] = JSON.stringify(value);
        }
        squiffy.ui.settings.onSet(attribute, value);
    };

    squiffy.get = function(attribute) {
        var result;
        if (squiffy.ui.settings.persist && window.localStorage) {
            result = localStorage[squiffy.story.id + '-' + attribute];
        }
        else {
            result = squiffy.storageFallback[attribute];
        }
        if (!result) return null;
        return JSON.parse(result);
    };

    var startsWith = function(string, prefix) {
        return string.substring(0, prefix.length) === prefix;
    };

    var rotate = function(options, current) {
        var colon = options.indexOf(':');
        if (colon == -1) {
            return [options, current];
        }
        var next = options.substring(0, colon);
        var remaining = options.substring(colon + 1);
        if (current) remaining += ':' + current;
        return [next, remaining];
    };

    var methods = {
        init: function (options) {
            var settings = jQuery.extend({
                scroll: 'body',
                persist: true,
                restartPrompt: true,
                onSet: function (attribute, value) {}
            }, options);

            squiffy.ui.output = this;
            squiffy.ui.restart = jQuery(settings.restart);
            squiffy.ui.settings = settings;

            if (settings.scroll === 'element') {
                squiffy.ui.output.css('overflow-y', 'auto');
            }

            initLinkHandler();
            squiffy.story.begin();
            
            return this;
        },
        get: function (attribute) {
            return squiffy.get(attribute);
        },
        set: function (attribute, value) {
            squiffy.set(attribute, value);
        },
        restart: function () {
            if (!squiffy.ui.settings.restartPrompt || confirm('Are you sure you want to restart?')) {
                squiffy.story.restart();
            }
        }
    };

    jQuery.fn.squiffy = function (methodOrOptions) {
        if (methods[methodOrOptions]) {
            return methods[methodOrOptions]
                .apply(this, Array.prototype.slice.call(arguments, 1));
        }
        else if (typeof methodOrOptions === 'object' || ! methodOrOptions) {
            return methods.init.apply(this, arguments);
        } else {
            jQuery.error('Method ' +  methodOrOptions + ' does not exist');
        }
    };
})();

var get = squiffy.get;
var set = squiffy.set;


squiffy.story.start = '_default';
squiffy.story.id = 'ed37112aa4';
squiffy.story.sections = {
	'_default': {
		'text': "<p>Let us <a class=\"squiffy-link link-section\" data-section=\"begin\" role=\"link\" tabindex=\"0\">begin</a>.</p>",
		'passages': {
		},
	},
	'begin': {
		'text': "<p>People run about you screaming. The village is burning with a fiery rage only possessed beasts can cause. You hear the shrill cry of your younger brother as you see him slung over an orc’s shoulder. The orc is charging towards Rastrallal woods. What you can’t figure out is why orcs would attack. They have been at peace  with human beings for more than a century. Why would they suddenly break the treaty? You see your father fending off an orc. You should help him!</p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"help\" role=\"link\" tabindex=\"0\">help</a> or <a class=\"squiffy-link link-section\" data-section=\"cower in fright\" role=\"link\" tabindex=\"0\">cower in fright</a>.</p>",
		'passages': {
		},
	},
	'help': {
		'text': "<p>You rush up behind the orc that is attacking your father. The orc turns around and snarls at you. Just then, your father slams his sword down on the orc&#39;s head. The orc falls to the ground, dead. When the orc dies, it falls in a patch of torchlight. You look down and notice that its face is different from that of the orcs you have watched the merchants trading with. This orc is heavily muscled and its eyes are blood-red. As you watch, a small worm exits a hole in the orc’s cheek. It squirms along the ground towards you.</p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"stomp on it\" role=\"link\" tabindex=\"0\">stomp on it</a> or <a class=\"squiffy-link link-section\" data-section=\"examine it\" role=\"link\" tabindex=\"0\">examine it</a>.</p>",
		'passages': {
		},
	},
	'cower in fright': {
		'text': "<p>You run around, looking for safety for yourself. Your father manages to kill his attacker. He rushes over to you. &#39;Look at that orc&#39;s body! Something is possessing these orcs.&#39;\nYou examine it and notice that its face is different from that of the orcs you have watched the merchants trading with. This orc is heavily muscled and its eyes are blood-red. As you watch, a small worm exits a hole in the orc’s cheek. It squirms along the ground towards you.</p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"stomp on it\" role=\"link\" tabindex=\"0\">stomp on it</a> or <a class=\"squiffy-link link-section\" data-section=\"examine it\" role=\"link\" tabindex=\"0\">examine it</a>.</p>",
		'passages': {
		},
	},
	'stomp on it': {
		'text': "<p>You stomp on what you hope is the worm&#39;s head with your boot and kill it. Then the orc carrying your little brother takes a boat and begins to paddle away. </p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"run towards the dock\" role=\"link\" tabindex=\"0\">run towards the dock</a> or you can <a class=\"squiffy-link link-section\" data-section=\"go to dad\" role=\"link\" tabindex=\"0\">go to dad</a>.</p>",
		'passages': {
		},
	},
	'examine it': {
		'text': "<p>You look closer at this worm. It is pale white and squirms around on the ground. These worms must have been controlling the orcs that attacked your town! To make sure that this worm does no more damage, you crunch its head under your boot heel. Then the orc carrying your little brother takes a boat and begins to paddle away. </p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"run towards the dock\" role=\"link\" tabindex=\"0\">run towards the dock</a> or you can <a class=\"squiffy-link link-section\" data-section=\"go to dad\" role=\"link\" tabindex=\"0\">go to dad</a>.</p>",
		'passages': {
		},
	},
	'run towards the dock': {
		'text': "<p>You run to the dock but there is nothing you can do. The orc paddles away too quickly and after that the battle dies down.</p>\n<p><a class=\"squiffy-link link-section\" data-section=\"Continue...\" role=\"link\" tabindex=\"0\">Continue...</a></p>",
		'passages': {
		},
	},
	'go to dad': {
		'text': "<p>Dad yells at you to return to the house and you obey. Sadly, the orc escapes from your father. After that, the battle subsides. </p>\n<p><a class=\"squiffy-link link-section\" data-section=\"Continue...\" role=\"link\" tabindex=\"0\">Continue...</a></p>",
		'passages': {
		},
	},
	'Continue...': {
		'text': "<p>You wake up, cold sweat on your forehead. Once again you have dreamed about that fateful night when you lost your brother. The next day, your father went into Rastrallal wood to search for your brother. Neither were ever seen again. This was a year ago. You wanted to go, but were too young. You have provided for yourself and have still have not spent much of the money that your father gave you. You keep it tucked away in a cabinet in the kitchen.</p>\n<p>You work in a mine. While it is grueling labor, it pays your expenses. Today is your last day at the mine. At the exit is a chest containing your paycheck. You open it and inside is a black cloak. Interesting. You then leave the mine to go home. Back at your house, you set down a work pack. You walk into your room. Inside, there is a stool with a mirror behind it.</p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"change your clothes\" role=\"link\" tabindex=\"0\">change your clothes</a> or <a class=\"squiffy-link link-section\" data-section=\"stare in the mirror\" role=\"link\" tabindex=\"0\">stare in the mirror</a>.</p>",
		'passages': {
		},
	},
	'change your clothes': {
		'text': "<p>You put on nicer clothes. You decide that you finally have saved enough money to search for your brother. You decide to ask the king for supplies. </p>\n<p>You arrive at the king&#39;s palace and knock on the huge wooden doors. A guard opens the door and looks around, pretending not to see anyone. </p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"politely clear your throat\" role=\"link\" tabindex=\"0\">politely clear your throat</a> or <a class=\"squiffy-link link-section\" data-section=\"kick the guard in the shins\" role=\"link\" tabindex=\"0\">kick the guard in the shins</a>.</p>",
		'passages': {
		},
	},
	'stare in the mirror': {
		'text': "<p>You look at yourself in the mirror. While you probably could stand here all day, you have more important things to do. You decide that you finally have saved enough money to search for your brother. You decide to ask the king for supplies. </p>\n<p>You arrive at the king&#39;s palace and knock on the huge wooden doors. A guard opens the door and looks around, pretending not to see anyone. </p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"politely clear your throat\" role=\"link\" tabindex=\"0\">politely clear your throat</a> or <a class=\"squiffy-link link-section\" data-section=\"kick the guard in the shins\" role=\"link\" tabindex=\"0\">kick the guard in the shins</a>.</p>",
		'passages': {
		},
	},
	'politely clear your throat': {
		'text': "<p>The guard laughs at your politeness and leads you <a class=\"squiffy-link link-section\" data-section=\"in the palace\" role=\"link\" tabindex=\"0\">in the palace</a>.</p>",
		'passages': {
		},
	},
	'kick the guard in the shins': {
		'text': "<p>As many know, a kick in the shins is very painful. Unfortunately for you, the guard was wearing armor on his shins. The only person hurt was you. The guard laughs at you and pushes you down to the ground. After that, he lets you <a class=\"squiffy-link link-section\" data-section=\"in the palace\" role=\"link\" tabindex=\"0\">in the palace</a>.</p>",
		'passages': {
		},
	},
	'in the palace': {
		'text': "<p>You enter a large hall with tons of pictures of kings before your time. The guard leads you to the king’s formal receiving room. Then you enter the courtroom. </p>\n<p>The King shoots an annoyed glare at the guard. “Why have you brought me this peasant?”</p>\n<p>The guard stutters. You snort to yourself, the guard is getting busted. You knew the only reason he let you come in was to embarrass yourself but that backfired. \nThe king turns to you. &quot;What are you here for?&quot;</p>\n<p>“Well sire,” you respond, “I am of age and I want to go on a quest to find my brother.”</p>\n<p>“Great.”</p>\n<p>“Can you at least give me something that I can have?”</p>\n<p>“Fine,” says the king. &quot;You can have this.”</p>\n<p>He summons his royal armorer, whispers something in his ear, then says that he can spare one sword only. He makes it seem like a big deal, even though his throne is probably worth 1000 of whatever he gives you.</p>\n<p>The king gives you a rusty sword, you take it, then leave the palace.</p>\n<p>Well, that went well, you think to yourself. You see a boy with black hair and gray rags watching you.</p>\n<p>Should you <a class=\"squiffy-link link-section\" data-section=\"speak to the beggar\" role=\"link\" tabindex=\"0\">speak to the beggar</a> or <a class=\"squiffy-link link-section\" data-section=\"continue on your way\" role=\"link\" tabindex=\"0\">continue on your way</a>?</p>",
		'passages': {
		},
	},
	'speak to the beggar': {
		'text': "<p>“Who are you?” you ask.</p>\n<p>“I’m just an orc out of place.” He responds.</p>\n<p>“You don’t look like an orc,” you say critically. </p>\n<p>“Yeah, I’m half-orc.&quot;</p>\n<p>“I see.”</p>\n<p>You go to the <a class=\"squiffy-link link-section\" data-section=\"village square\" role=\"link\" tabindex=\"0\">village square</a>.</p>",
		'passages': {
		},
	},
	'continue on your way': {
		'text': "<p>You walk away while the boy continues watching you. That’s weird, you think to yourself. You continue down the path and after a while, you notice that the boy has followed you. </p>\n<p>You raise your unsharpened sword as threateningly as you can and say, “What do you want?” </p>\n<p>The boy cocks his head and says, “Nothing. I just couldn’t help but see that you looked lost.”</p>\n<p>“Well, I’m not, so you can stop following me now.”</p>\n<p>The boy holds his hands up in a &#39;well, aren’t you a ball of sunshine&#39; gesture.</p>\n<p>You go to the <a class=\"squiffy-link link-section\" data-section=\"village square\" role=\"link\" tabindex=\"0\">village square</a>.</p>",
		'passages': {
		},
	},
	'village square': {
		'text': "<p>There are four establishments that look promising. An <a class=\"squiffy-link link-passage\" data-passage=\"armor shop\" role=\"link\" tabindex=\"0\">armor shop</a>, a <a class=\"squiffy-link link-passage\" data-passage=\"weapon shop\" role=\"link\" tabindex=\"0\">weapon shop</a>, a <a class=\"squiffy-link link-passage\" data-passage=\"magical items shop\" role=\"link\" tabindex=\"0\">magical items shop</a>, or a <a class=\"squiffy-link link-passage\" data-passage=\"tavern\" role=\"link\" tabindex=\"0\">tavern</a>.</p>",
		'passages': {
			'armor shop': {
				'text': "<p>You go there and you buy chainmail armor.</p>\n<p>You should probably go the the <a class=\"squiffy-link link-section\" data-section=\"dock\" role=\"link\" tabindex=\"0\">dock</a>.</p>",
			},
			'weapon shop': {
				'text': "<p>You go there and buy a battle-ax.</p>\n<p>You should probably go the the <a class=\"squiffy-link link-section\" data-section=\"dock\" role=\"link\" tabindex=\"0\">dock</a>.</p>",
			},
			'magical items shop': {
				'text': "<p>You go there and buy a scroll, with which you learn a spell.</p>\n<p>You should probably go the the <a class=\"squiffy-link link-section\" data-section=\"dock\" role=\"link\" tabindex=\"0\">dock</a>.</p>",
			},
			'tavern': {
				'text': "<p>You go into the tavern and look around. It looks like the usual description of a tavern. You see glass on the floor and wonder if it was such a good idea to come in here. “Whatcha want?” Calls the raggedy tavern keeper, “You look a little young to be in here.” </p>\n<p>You can say, <a class=\"squiffy-link link-section\" data-section=\"“I don't need anything but a dinner”\" role=\"link\" tabindex=\"0\">“I don&#39;t need anything but a dinner”</a> or stand tall and say, <a class=\"squiffy-link link-section\" data-section=\"“I can take on anyone\" role=\"link\" tabindex=\"0\">“I can take on anyone</a> any day, no matter how tall or strong! And that includes you and others who insult me!”  </p>",
			},
		},
	},
	'“I can take on anyone': {
		'text': "<p>The tavern keeper grins. He is the type of person who enjoys fights. “You want to make good on your boast?” he says. He points to a dark corner. “Over there is a man named Mark Hammerfist. He is called that because of his fighting skills. He is the champion here. Beat him, and I will give you a free meal and 20 yen.”</p>\n<p>You agree.</p>\n<p>You set your weapons and armor down on the counter and step up onto a raised platform. The men in the tavern begin pounding their cups of ale on the table in a steady rythym. &quot;Fight! Fight! Fight!&quot;</p>\n<p>You attack first and hit Mark in his nose. He grunts and seems uninjured. He strikes at you like lightning. Fortunately, your reflexes are well-tuned. You dodge, grab Mark&#39;s forearm, and, using his momentum, throw him off the platform. The tavern cheers.</p>\n<p>The tavern keeper grudgingly gives you the promised rewards.</p>\n<p>You should probably go the the <a class=\"squiffy-link link-section\" data-section=\"dock\" role=\"link\" tabindex=\"0\">dock</a>.</p>",
		'passages': {
		},
	},
	'“I don\'t need anything but a dinner”': {
		'text': "<p>You buy a dinner for yourself and eat it quietly.</p>\n<p>You should probably go to the <a class=\"squiffy-link link-section\" data-section=\"dock\" role=\"link\" tabindex=\"0\">dock</a>.</p>",
		'passages': {
		},
	},
	'dock': {
		'text': "<p>After you get your stuff, you walk towards the dock. As you&#39;re walking, you have flashbacks of that night. You shake your head to snap out of it. Then beggar, still following you, asks if you&#39;re ok. </p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"answer the beggar\" role=\"link\" tabindex=\"0\">answer the beggar</a> or <a class=\"squiffy-link link-section\" data-section=\"ignore him\" role=\"link\" tabindex=\"0\">ignore him</a>.</p>",
		'passages': {
		},
	},
	'answer the beggar': {
		'text': "<p>“I’m fine,” you say.</p>\n<p>“But you don’t…” he says.</p>\n<p>“I said “I&#39;m fine!” you growl.</p>\n<p>He sighs. &quot;My name is Troy. I would like to help you wherever you are going.&quot;</p>\n<p>You suspiciously ask, &quot;Why? What&#39;s in it for you?&quot;</p>\n<p>He grunts. &quot;I noticed that you are on the dock. Most of my family lives across the lake. I thought we could possibly go together. I can handle myself in a fight.&quot;</p>\n<p>You decide that someone to keep your back would be helpful. &quot;Fine.&quot;</p>\n<p>You and Troy buy a rowboat and <a class=\"squiffy-link link-section\" data-section=\"head off\" role=\"link\" tabindex=\"0\">head off</a>.</p>",
		'passages': {
		},
	},
	'ignore him': {
		'text': "<p>He waits for you to answer and then sighs. &quot;My name is Troy. I would like to help you wherever you are going.&quot;</p>\n<p>You suspiciously ask, &quot;Why? What&#39;s in it for you?&quot;</p>\n<p>He grunts. &quot;I noticed that you are on the dock. Most of my family lives across the lake. I thought we could possibly go together. I can handle myself in a fight.&quot;</p>\n<p>You decide that someone to keep your back would be helpful. &quot;Fine.&quot;</p>\n<p>You and Troy buy a rowboat and <a class=\"squiffy-link link-section\" data-section=\"head off\" role=\"link\" tabindex=\"0\">head off</a>.</p>",
		'passages': {
		},
	},
	'head off': {
		'text': "<p>You have completed the sea leg of your journey and have just landed. Rastrallal wood is dark and gloomy. You and Troy stick together and explore until the sun dips below the horizon. You build a fire and sit around it, roasting a deer Troy killed. When the deer is done roasting you cut it up with your knife. You and Troy are not able to eat it all, so you pack up some and put it in your pack. With your stomach full and blazing fire, you start to wonder how long you were actually on the water. </p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"ask Troy how much time passed\" role=\"link\" tabindex=\"0\">ask Troy how much time passed</a> or <a class=\"squiffy-link link-section\" data-section=\"just sit and enjoy the cool night air\" role=\"link\" tabindex=\"0\">just sit and enjoy the cool night air</a>.</p>",
		'passages': {
		},
	},
	'ask Troy how much time passed': {
		'text': "<p>“Hey, Troy, how long were we on the water?” you ask.\n“We were on that lake for about two full moons. Why?&quot; he looks at you.\n“Thanks. For some reason I just wasn&#39;t keeping track of the time,” you admit. </p>\n<p>Later, you feel tired and your head starts to nod. Troy volunteers to take the first watch. He is supposed to wake you up in an hour, but something jolts you awake in the middle of the night. You look around for Troy, but do not see him. You search the cave and find no sign of him. The next thing you hear is a yell that sounds like Troy. </p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"look for Troy\" role=\"link\" tabindex=\"0\">look for Troy</a> or <a class=\"squiffy-link link-section\" data-section=\"search for signs\" role=\"link\" tabindex=\"0\">search for signs</a>.</p>",
		'passages': {
		},
	},
	'just sit and enjoy the cool night air': {
		'text': "<p>You sit for a while and look at the stars.</p>\n<p>Later, you feel tired and your head starts to nod. Troy volunteers to take the first watch. He is supposed to wake you up in an hour, but something jolts you awake in the middle of the night. You look around for Troy, but do not see him. You search the cave and find no sign of him. The next thing you hear is a yell that sounds like Troy. </p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"look for Troy\" role=\"link\" tabindex=\"0\">look for Troy</a> or <a class=\"squiffy-link link-section\" data-section=\"search for signs\" role=\"link\" tabindex=\"0\">search for signs</a>.</p>",
		'passages': {
		},
	},
	'look for Troy': {
		'text': "<p>You go walking towards that sound and you find Troy in pitched battle with a ghoul. You take on the ghoul and beat it. When you finish, you see cuts and bruises all over Troy and his clothes are ripped. He then he passes out. You drag his body under a tree and look around for something to help him. Suddenly, you see a scouting party of orcs.</p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"ask them for help\" role=\"link\" tabindex=\"0\">ask them for help</a> or <a class=\"squiffy-link link-section\" data-section=\"flee for your life\" role=\"link\" tabindex=\"0\">flee for your life</a>.</p>",
		'passages': {
		},
	},
	'search for signs': {
		'text': "<p>You walk to your tent to grab your weapons but, out of nowhere, a man in all black with fangs white as snow comes and jumps on you. After you knock him off of you, you see a dagger, which he dropped, and use it against him. You plunge the dagger into his chest and he gives on last forlorn howl and falls to the ground. You then look for Troy.</p>\n<p>You find Troy in pitched battle with another ghoul. You take on the ghoul and beat it. When you finish, you see cuts and bruises all over Troy and his clothes are ripped. He then he passes out. You drag his body under a tree and look around for something to help him. Suddenly, you see a scouting party of orcs.</p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"ask them for help\" role=\"link\" tabindex=\"0\">ask them for help</a> or <a class=\"squiffy-link link-section\" data-section=\"flee for your life\" role=\"link\" tabindex=\"0\">flee for your life</a>.</p>",
		'passages': {
		},
	},
	'ask them for help': {
		'text': "<p>You push down the fear of getting gruesomely killed and wave at the orcs saying, “I have one of your own kind who is wounded. We were traveling together.” The biggest one snorts, but says something to the other orcs in a different language.  They take you to their village and put you under heavy guard. The orcs are not used to outsiders. You learn that this was Troy&#39;s hometown after putting him in the medical tent. \nYou are a little angry that Troy abandoned his watch.</p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"voice your disappointment\" role=\"link\" tabindex=\"0\">voice your disappointment</a> or <a class=\"squiffy-link link-section\" data-section=\"get over it\" role=\"link\" tabindex=\"0\">get over it</a>.</p>",
		'passages': {
		},
	},
	'flee for your life': {
		'text': "<p>The orc scouting party spots you. They surround you before you even have a chance to draw your weapons. They put you under heavy guard but still take you to their village. The orcs are not used to outsiders. You learn that this was Troy&#39;s hometown after putting him in the medical tent. \nTroy weakly croaks, “I once lived here. This is my home.”\nYou are a little angry that Troy abandoned his watch.</p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"voice your disappointment\" role=\"link\" tabindex=\"0\">voice your disappointment</a> or <a class=\"squiffy-link link-section\" data-section=\"get over it\" role=\"link\" tabindex=\"0\">get over it</a>.</p>",
		'passages': {
		},
	},
	'voice your disappointment': {
		'text': "<p>&quot;Why weren&#39;t you on the watch, you idiot?&quot; you yell at him.\nTroy looks at you and then his eyes close.\nYou shake him and find out that he has passed out.</p>\n<p>Gradually, the orcs become used to your presence. You visit the medical tent often, checking on your friend. It appears that he is gradually getting better, and after a period of a few weeks, he appears to be in full health.</p>\n<p>One day, you are lounging around, looking for something to do, when you hear a loud crunch from the north side of the city. You run towards it and find a golem. It has killed many brave guards already. You must stop this creature of destruction!</p>\n<p>You walk towards the golem. As you do so, you can see people running away from it.  You hear a loud bang, Then you run towards it and you see a golem smashing and running through buildings. You spot the golem about to step on a baby.</p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"save the baby\" role=\"link\" tabindex=\"0\">save the baby</a> or <a class=\"squiffy-link link-section\" data-section=\"go after the golem\" role=\"link\" tabindex=\"0\">go after the golem</a>.</p>",
		'passages': {
		},
	},
	'get over it': {
		'text': "<p>You don&#39;t say anything.</p>\n<p>Gradually, the orcs become used to your presence. You visit the medical tent often, checking on your friend. It appears that he is gradually getting better, and after a period of a few weeks, he appears to be in full health.</p>\n<p>One day, you are lounging around, looking for something to do, when you hear a loud crunch from the north side of the city. You run towards it and find a golem. It has killed many brave guards already. You must stop this creature of destruction!</p>\n<p>You walk towards the golem. As you do so, you can see people running away from it.  You hear a loud bang, Then you run towards it and you see a golem smashing and running through buildings. You spot the golem about to step on a baby.</p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"save the baby\" role=\"link\" tabindex=\"0\">save the baby</a> or <a class=\"squiffy-link link-section\" data-section=\"go after the golem\" role=\"link\" tabindex=\"0\">go after the golem</a>.</p>",
		'passages': {
		},
	},
	'save the baby': {
		'text': "<p>You run toward the baby at full speed, and when you are about 10 feet away you do a tuck and roll and grab the baby. Then you toss it on a mattress safe and sound, but the golem’s left foot steps on you.</p>\n<p>You have died. </p>\n<p>You must <a class=\"squiffy-link link-section\" data-section=\"begin\" role=\"link\" tabindex=\"0\">begin</a> again.</p>",
		'passages': {
		},
	},
	'go after the golem': {
		'text': "<p>You hit it with the sword but it breaks and you are hit. The golem then steps on the baby and kills it. Then it starts running to you, but your leg is stuck under some rubble. Just in time, Troy rushes in on the scene. He has fully recovered from the ghoul incident and he defeats the golem to save you.</p>\n<p>Troy frees you from the rubble and takes you to a <a class=\"squiffy-link link-section\" data-section=\"hut\" role=\"link\" tabindex=\"0\">hut</a>.</p>",
		'passages': {
		},
	},
	'hut': {
		'text': "<p>Troy gives you a sketch of himself and an orc woman in a white dress. You look closer and notice that her face is smudged. You fold the sketch and put it in your pocket because they remind you of someone, then walk out to the <a class=\"squiffy-link link-section\" data-section=\"market\" role=\"link\" tabindex=\"0\">market</a>.</p>",
		'passages': {
		},
	},
	'market': {
		'text': "<p>Suddenly a trumpet resounds in the city. You are being summoned to the king orc! You know not why. Guards surround you and try to lead you to the king.</p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"go peacefully with them\" role=\"link\" tabindex=\"0\">go peacefully with them</a> or <a class=\"squiffy-link link-section\" data-section=\"fight them\" role=\"link\" tabindex=\"0\">fight them</a>.</p>",
		'passages': {
		},
	},
	'go peacefully with them': {
		'text': "<p>You peacefully cooperate with the guards and they bring you to the <a class=\"squiffy-link link-section\" data-section=\"king\" role=\"link\" tabindex=\"0\">king</a>. </p>",
		'passages': {
		},
	},
	'fight them': {
		'text': "<p>You begin to lay about you with your fists. There are so many guards that they overwhelm you. Though a few leave with black eyes or bloody noses, none are seriously injured. They still bring you to the <a class=\"squiffy-link link-section\" data-section=\"king\" role=\"link\" tabindex=\"0\">king</a>.</p>",
		'passages': {
		},
	},
	'king': {
		'text': "<p>The king says, “I regret to do this, but it is out of necessity. I will get straight to the point. You must be out of this city by tomorrow morning.”\nYou gasp. “But...why? Have I done anything but good here? Show me my wrong and I will gladly leave.”\nThe king sighs. “It is not something that you have done wrong. The golem that ransacked the north part of the city was sent by our feral ‘cousins’. They are searching for you and we have received messengers saying that if you do not leave, they will continue terrorizing the people.”\n“I understand, O King.”\nTroy, who has not said anything yet, says, “I will go with you! You are my friend, and though we started out roughly, you have yet to abandon me. You saved me from the ghoul. This is the only way that I can repay you.”\nThe king then <a class=\"squiffy-link link-section\" data-section=\"dismisses\" role=\"link\" tabindex=\"0\">dismisses</a> you.</p>",
		'passages': {
		},
	},
	'dismisses': {
		'text': "<p>After gathering supplies for a journey, you return to the forest. As you walk deeper into the woods you start to hear the shrill cry of your younger brother again, and you once again seem to see the outline of the orc running with him. </p>\n<p>Troy startles you out of your recollections by saying, “We should find shelter.”\nYou sarcastically say, “You don’t think I know that?”\nTroy bluntly states, “You showed no sign of your intelligence on this matter...”\n“Anyway, I looked over a map of this place while we were still at the village so there should be a cave near here.”</p>\n<p>After some time walking in the cold, you find a cave and set up camp there. You sleep. The next day you wake up from a dream of your brother calling for help. You want to be alone and think for a short time.</p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"leave by yourself\" role=\"link\" tabindex=\"0\">leave by yourself</a> or <a class=\"squiffy-link link-section\" data-section=\"wake Troy\" role=\"link\" tabindex=\"0\">wake Troy</a>.</p>",
		'passages': {
		},
	},
	'leave by yourself': {
		'text': "<p>You leave the cave to be alone for a little while. After about an hour of quiet meditation, you hear something slipping into the heavy snow behind you. You turn around only to see Troy.\nYou suspiciously say, “Wait, what are you doing here?”\nTroy shrugs. “I could ask you the same thing.&quot;\n“I don’t know, I wanted to be alone for a while.”\nTroy grunts.</p>\n<p>You go <a class=\"squiffy-link link-section\" data-section=\"back to the cave\" role=\"link\" tabindex=\"0\">back to the cave</a>.</p>",
		'passages': {
		},
	},
	'wake Troy': {
		'text': "<p>You shake Troy awake and tell him that now is a good time to wake up. You walk together for about an hour in silence and then you spot a deer. Troy aims and looses an arrow at it. The deer drops to the ground, and you and Troy carry it <a class=\"squiffy-link link-section\" data-section=\"back to the cave\" role=\"link\" tabindex=\"0\">back to the cave</a>.</p>",
		'passages': {
		},
	},
	'back to the cave': {
		'text': "<p>You suggest exploring the cave further. The cave’s passageways are extensive and you wander around in them with Troy. It is then that you notice that whenever passageways intersect, there is a mark pointing a certain way. You point it out to Troy and you follow the marks. After perhaps a mile of walking in the underground maze, you find a crack that spills light on the ground. It appears that this is a secret entrance into a courtyard of a stone castle. Feral orcs patrol the walls of the place. You also spot a ghoul walking in.</p>\n<p>You almost shout, “Shazia, my brother, is here!”\nTroy looks worried. “We can’t go in.”\nCalming down, you say, “We will retrieve our supplies from the <a class=\"squiffy-link link-section\" data-section=\"cave\" role=\"link\" tabindex=\"0\">cave</a> and camp there one more night.”</p>",
		'passages': {
		},
	},
	'cave': {
		'text': "<p>As you pack, you see a leather book fall out of Troy&#39;s bag. When you open it you see drawings and notes of everything he meets, even you. It said that you are very secretive, your plans aren’t that smart but they work. You hand the book back to him and sit down <a class=\"squiffy-link link-section\" data-section=\"by the fire\" role=\"link\" tabindex=\"0\">by the fire</a>.</p>",
		'passages': {
		},
	},
	'by the fire': {
		'text': "<p>You ask Troy, &quot;Do you have a plan to get in ?”</p>\n<p>“Yes, and all we need is a black cloak,” Troy answers</p>\n<p>“Lucky for me, I always have one.” You remove it from your pack.</p>\n<p>“Good, then we enter at dawn, but may I ask, who are we trying to save?”</p>\n<p>“I’m trying to save my brother, and hopefully my father too.”</p>\n<p>After a good night&#39;s sleep, you mobilize. You go over the plan again with Troy and decide to enter the <a class=\"squiffy-link link-section\" data-section=\"dungeons\" role=\"link\" tabindex=\"0\">dungeons</a>, thinking that at least one of them will be in there.</p>",
		'passages': {
		},
	},
	'dungeons': {
		'text': "<p>After descending several long staircases you finally come to the dungeons. The stench of rotting flesh began at about the third staircase down and has definitely worsened. As you get to the bottom of the staircase, you find more guards. Troy speaks to them and they allow you to <a class=\"squiffy-link link-section\" data-section=\"pass\" role=\"link\" tabindex=\"0\">pass</a>.</p>",
		'passages': {
		},
	},
	'pass': {
		'text': "<p>When no one is in sight, Troy unbinds your arms and you look around. The contents of the cells vary, yet you find nothing living. Some cells only contain bones, others have corpses that still have some flesh left on them. What is interesting, though, is that the bodies are never whole. Some have lost arms. Those prisoners were the lucky ones. It appears that others have been bent backwards over stone altars made for just that purpose.\n<a class=\"squiffy-link link-section\" data-section=\"Continue\" role=\"link\" tabindex=\"0\">Continue</a></p>",
		'passages': {
		},
	},
	'Continue': {
		'text': "<p>After searching for a while, you say, &quot;They must not be here in the dungeons! Could they be...No. They are still alive. But where would they be?&quot;\n“Maybe they&#39;re in a different part of this place,” Troy suggests.\n“I just don’t get it,” you grumble.\nTroy&#39;s face lights up. “What about the <a class=\"squiffy-link link-section\" data-section=\"throne room\" role=\"link\" tabindex=\"0\">throne room</a>?” \nYou doubt it. “Why would he be there?”\n“Why not?”</p>",
		'passages': {
		},
	},
	'throne room': {
		'text': "<p>Troy loosely ties your arms and you ascend the long staircases. Finally, you get there. No guards bar your way. This surprises you. You think about it for a moment, then dismiss it as nothing. The throne room is vast and spacious. Your father is nowhere to be seen, but in the middle of the room, you see your younger brother. Shazia is on a chain and <a class=\"squiffy-link link-section\" data-section=\"holding the chain is an orc\" role=\"link\" tabindex=\"0\">holding the chain is an orc</a>.</p>",
		'passages': {
		},
	},
	'holding the chain is an orc': {
		'text': "<p>&quot;Quit moving or I will twist you into knots!&quot; the orc yells.</p>\n<p>You try to lunge forward but Troy holds you back and claps his hand over your mouth. You see the sense in this and do not struggle.\nThe orc growls, “Show yourself or it is the end for you, whoever you may be!&quot;\n&quot;Stay here,&quot; Troy orders.\nTroy walks up to the orc and says “lt is only I, coming to bring Shazia to the master.&quot;\nThe orc suspiciously looks at Troy. &quot;Who are you? I have not seen you about here before. You are like a small one, yet pretend to have the authority of a full one. If you were truly sent by the master, he would have given you a sign to show guards. Show it to me, and you shall have the prisoner.&quot;\nTroy sighs. “We are doing this the hard way, then.” With a ringing sound of steel, he draws his sword from his sheath.</p>\n<p>You  can <a class=\"squiffy-link link-section\" data-section=\"hide from the orc\" role=\"link\" tabindex=\"0\">hide from the orc</a> or <a class=\"squiffy-link link-section\" data-section=\"back Troy up\" role=\"link\" tabindex=\"0\">back Troy up</a>.</p>",
		'passages': {
		},
	},
	'hide from the orc': {
		'text': "<p>You stay away from the combat, feeling that Troy can take on at least one orc. Didn&#39;t he say he could handle himself in a fight?</p>\n<p>After Troy finishes off the orc, you have a <a class=\"squiffy-link link-section\" data-section=\"word with Shazia\" role=\"link\" tabindex=\"0\">word with Shazia</a>.</p>",
		'passages': {
		},
	},
	'back Troy up': {
		'text': "<p>You help him take on the orc and easily finish off this one.\nYou decide to have a <a class=\"squiffy-link link-section\" data-section=\"word with Shazia\" role=\"link\" tabindex=\"0\">word with Shazia</a>.</p>",
		'passages': {
		},
	},
	'word with Shazia': {
		'text': "<p>First things first. You ask, “Where’s dad?”</p>\n<p>Shazia says, “Hello to you too. He was taken from me at the beginning. Every few days they let me see him, but I haven’t seen him for 2 weeks now. I think he might be dead.&quot;</p>\n<p>You bite your tongue. “I know he wouldn&#39;t give up that easily. He’s still alive. ”</p>\n<p>“I know, but don’t get your hopes up. They had no use for him, so they must’ve killed him. I can’t believe I’m still alive.”</p>\n<p>“Since when did you become so cynical?”</p>\n<p>“Since I was locked up in a cage for years! What do you think? I’ve been beaten about a dozen times for not telling them what they want to know. I don’t even know what they want to know! Something about a wrong that must be righted or something like that. I wasn’t even conscious half the time.&quot; </p>\n<p>You <a class=\"squiffy-link link-section\" data-section=\"end the conversation\" role=\"link\" tabindex=\"0\">end the conversation</a>.</p>",
		'passages': {
		},
	},
	'end the conversation': {
		'text': "<p>Suddenly the doors of the room burst open and you sense a cold entity. A ghoul steps forth and grabs Troy with its icy-cold fingers. Troy lets forth a strangled cry. </p>\n<p>You can <a class=\"squiffy-link link-section\" data-section=\"help Troy again\" role=\"link\" tabindex=\"0\">help Troy again</a> or <a class=\"squiffy-link link-section\" data-section=\"leave him\" role=\"link\" tabindex=\"0\">leave him</a>.</p>",
		'passages': {
		},
	},
	'help Troy again': {
		'text': "<p>You help Troy and you both escape the orc palace.</p>\n<p>When you get home, you are praised for saving the realm.</p>",
		'passages': {
		},
	},
	'leave him': {
		'text': "<p>Troy dies.</p>\n<p>You and Shazia escape the orc palace.</p>\n<p>When you get home, you are praised for saving the realm.</p>",
		'passages': {
		},
	},
}
})();